from MoinMoin import config, util, wikiutil
from MoinMoin.Page import Page
from MoinMoin.util import MoinMoinNoFooter, pysupport
from DescriptionSetProfile import DescriptionSet
"""
     output xml format with text/xml Content-type header
     This method is the entry-point called when the parser is executed.
     The content type is first set, then the text is split into separate lines 
     and parsed. The internal representation of the Description Set Template is 
     then created and transformed into XML according to the Description Set 
     Profile XML-schema
""" 
def execute(pagename, request):
    if not request.user.may.read(pagename):
        Page(pagename).send_page(request)
        return

    request.http_headers(["Content-type: text/xml;charset=%s" % config.charset])

    page = Page(request, pagename)

    raw_text = page.get_raw_body()

    start = raw_text.find("{{{#!DSP")
    if(start > -1 ):

        newString = raw_text[start:]

        end = newString.find("}}}")

        if(end>-1):
            newString = newString[:end]

        ##sio = StringIO.StringIO(newString)
        ##shutil.copyfileobj(sio, therequest) 
        splitLines = newString.splitlines()
        DST = parseLines(splitLines[1:])
        xmlString = DST.toXMLString()
        request.write("<?xml version=\"1.0\"?>\n"+xmlString)
    else:
        request.write("<error>No Description Set Profile found</error>")
    raise MoinMoinNoFooter

        
""" This method builds the internal representation of the Description Set 
        Profile"""
def parseLines(splitLines):
    descriptionSetTemplate = DescriptionSet.DescriptionSetTemplate()
    while(len(splitLines)>0):
        string = splitLines[0]
        if(string.lower().startswith("dt")):
            DTString = string
            i=1
            while not(DTString.count("(") == DTString.count(")")) and i<len(splitLines):
                DTString += splitLines[i] 
                i = i+1
            splitLines = splitLines[i:]
            dt = DescriptionSet.DescriptionTemplate(DTString)
            descriptionSetTemplate.addDescriptionTemplate(dt)#TODO:
        elif(string.lower().startswith("st=")):
            STString = string
            i=1
            while not(STString.count("(") == STString.count(")")) and i<len(splitLines):
                STString += splitLines[i] 
                i += 1
            st = DescriptionSet.StatementTemplate(STString)
            splitLines = splitLines[i:]
            descriptionSetTemplate.addStatmentTemplate(st)#TODO
        elif(string.lower().startswith("lc")):
            LCString = string
            i=1
            while not(LCString.count("(") == LCString.count(")")) and i<len(splitLines):
                LCString += splitLines[i] 
                i += 1
            lc = DescriptionSet.LiteralConstraint(LCString)
            splitLines = splitLines[i:]
            descriptionSetTemplate.addLiteralConstraint(lc)
        elif(string.lower().startswith("nlc")):
            NLCString = string
            i=1
            while not(NLCString.count("(") == NLCString.count(")")) and i<len(splitLines):
                NLCString += splitLines[i] 
                i += 1
            nlc = DescriptionSet.NonLiteralConstraint(NLCString)
            splitLines = splitLines[i:]
            descriptionSetTemplate.addNonLiteralConstraint(nlc)#TODO
        else:
            descriptionSetTemplate.addNormalWikiSyntax(splitLines[0])
            splitLines = splitLines[1:]
    return descriptionSetTemplate


