from MoinMoin.parser import wiki
from DescriptionSetProfile import DescriptionSet

class Parser:
    def __init__(self, raw, request, **kw):
        """ Store the source text.
        """
        self.raw = raw
        self.request = request
        self.form = request.form
        self._ = request.getText
        self.events = {}
        self.optionsItems = {}
        self.options = None
        self.calendars = []
        self.debug = []
        self.descriptionSetTemplate = DescriptionSet.DescriptionSetTemplate()
    
    """ This method is the entry-point called when the parser is executed.
        The first step is to split the lines and then parse them. The internal 
        representation of the Description Set Template is created. Everything is
        then transformed into normal moinmoin-wiki syntax and sent to the normal 
        wiki-parser  """
    def format(self, formatter):
        splitLines = self.raw.splitlines()
        self.parseLines(splitLines)
        inputString = self.descriptionSetTemplate.__str__()
        p = wiki.Parser(inputString,self.request)
        p.format(formatter)

    """ This method builds the internal representation of the Description Set 
        Profile"""
    def parseLines(self, splitLines):
        while(len(splitLines)>0):
            string = splitLines[0]
            if(string.lower().startswith("dt")):
                DTString = string
                i=1
                while not(DTString.count("(") == DTString.count(")")) and i<len(splitLines):
                    DTString += splitLines[i] 
                    i = i+1
                splitLines = splitLines[i:]
                dt = DescriptionSet.DescriptionTemplate(DTString)
                self.descriptionSetTemplate.addDescriptionTemplate(dt)#TODO:
            elif(string.lower().startswith("st=")):
                STString = string
                i=1
                while not(STString.count("(") == STString.count(")")) and i<len(splitLines):
                    STString += splitLines[i] 
                    i += 1
                st = DescriptionSet.StatementTemplate(STString)
                splitLines = splitLines[i:]
                self.descriptionSetTemplate.addStatmentTemplate(st)#TODO
            elif(string.lower().startswith("lc")):
                LCString = string
                i=1
                while not(LCString.count("(") == LCString.count(")")) and i<len(splitLines):
                    LCString += splitLines[i] 
                    i += 1
                lc = DescriptionSet.LiteralConstraint(LCString)
                splitLines = splitLines[i:]
                self.descriptionSetTemplate.addLiteralConstraint(lc)
            elif(string.lower().startswith("nlc")):
                NLCString = string
                i=1
                while not(NLCString.count("(") == NLCString.count(")")) and i<len(splitLines):
                    NLCString += splitLines[i] 
                    i += 1
                nlc = DescriptionSet.NonLiteralConstraint(NLCString)
                splitLines = splitLines[i:]
                self.descriptionSetTemplate.addNonLiteralConstraint(nlc)#TODO
            else:
                self.descriptionSetTemplate.addNormalWikiSyntax(splitLines[0])
                splitLines = splitLines[1:]
    



